/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.context;

import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;

/**
 * This interface provides an abstraction for handle resource references.
 *
 * @Author Shing Wai Chan
 */
public interface ResourceContainerContext extends ServiceReferenceContainerContext {
    /**
     * Add a ejb reference.
     *
     * @param the ejb reference
     */
    public void addEjbReferenceDescriptor(EjbReference ejbReference);
                                                                               
    /**
     * Looks up an ejb reference with the given name.
     * Return null if it is not found.
     *
     * @param the name of the ejb-reference
     */
    public EjbReference getEjbReference(String name);

    /**
     * Add a resource reference
     *
     * @param the resource reference
     */
    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor 
                                               resReference);
                                                                               
    /**
     * Looks up an resource reference with the given name.
     * Return null if it is not found.
     *
     * @param the name of the resource-reference
     */
    public ResourceReferenceDescriptor getResourceReference(String name);

    /**
     * Add a message-destination-ref
     *
     * @param the msgDestRef
     */
    public void addMessageDestinationReferenceDescriptor
        (MessageDestinationReferenceDescriptor msgDestRef);
                                               
                                                                               
    /**
     * Looks up a message-destination-ref with the given name.
     * Return null if it is not found.
     *
     * @param the name of the message-destination-ref
     */
    public MessageDestinationReferenceDescriptor getMessageDestinationReference
        (String name);


   /**
     * Add a resource-env-ref
     *
     * @param the jmsDestRef
     */
    public void addJmsDestinationReferenceDescriptor
        (JmsDestinationReferenceDescriptor jmsDestRef);


    /**
     * Looks up a resource-env-ref with the given name.
     * Return null if it is not found.
     *
     * @param the name of the resource-env-ref
     */
    public JmsDestinationReferenceDescriptor getJmsDestinationReference
        (String name);

    /**
     * Add an env-entry
     *
     * @param the env-entry
     */
    public void addEnvEntryDescriptor(EnvironmentProperty envEntry);
                                               
                                                                               
    /**
     * Looks up an env-entry with the given name.
     * Return null if it is not found.
     *
     * @param the name of the env-entry
     */
    public EnvironmentProperty getEnvEntry(String name);


    public void addEntityManagerFactoryReferenceDescriptor
        (EntityManagerFactoryReferenceDescriptor emfRefDesc);
                                                                               
    /**
     * Looks up an entity manager factory reference with the given name.
     * Return null if it is not found.
     *
     * @param the name of the emf reference
     */
    public EntityManagerFactoryReferenceDescriptor 
        getEntityManagerFactoryReference(String name);

    public void addEntityManagerReferenceDescriptor
        (EntityManagerReferenceDescriptor emRefDesc);
                                                                               
    /**
     * Looks up an entity manager reference with the given name.
     * Return null if it is not found.
     *
     * @param the name of the emf reference
     */
    public EntityManagerReferenceDescriptor getEntityManagerReference
        (String name);

   /**
     * @param postConstructDesc
     */
    public void addPostConstructDescriptor(
            LifecycleCallbackDescriptor postConstructDesc);

    /**
     * Look up an post-construct LifecycleCallbackDescriptor with the
     * given name.  Return null if it is not found
     * @param className
     */
    public LifecycleCallbackDescriptor getPostConstruct(String className);

   /**
     * @param preDestroyDesc
     */
    public void addPreDestroyDescriptor(
            LifecycleCallbackDescriptor preDestroyDesc);

    /**
     * Look up an pre-destroy LifecycleCallbackDescriptor with the
     * given name.  Return null if it is not found
     * @param className
     */
    public LifecycleCallbackDescriptor getPreDestroy(String className);
}
