/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

import java.util.Map;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.xml.TagNames;

import com.sun.enterprise.deployment.Role;

/**
 *
 * @author  Jerome Dochez
 * @version 
 */
public class SecurityRoleNode extends DeploymentDescriptorNode {

   /**
     * Declare the setName method as an action on the SecurityRoleDescriptor, as initialized by the
     * DescriptorFactory.  
     * <p>
     * The DeploymentDescriptorNode superclass specifies the setDescription method for the description 
     * element, so we just add the setName action to that dispatch table.
     *  
     * @return the map with the element name as a key, the setter method as a value
     */
    protected Map getDispatchTable() {    
        Map table = super.getDispatchTable();
        table.put(TagNames.ROLE_NAME, "setName");
        return table;
    }

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, Role descriptor) {
        Node roleNode = appendChild(parent, nodeName);
        appendTextChild(roleNode, TagNames.DESCRIPTION, descriptor.getDescription());        
        appendTextChild(roleNode, TagNames.ROLE_NAME, descriptor.getName());
        return roleNode;
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, SecurityRoleDescriptor descriptor) {
        Node roleNode = appendChild(parent, nodeName);
        appendTextChild(roleNode, TagNames.DESCRIPTION, descriptor.getDescription());        
        appendTextChild(roleNode, TagNames.ROLE_NAME, descriptor.getName());
        return roleNode;
    }    
}
