/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.web;

import org.xml.sax.Attributes;
import org.w3c.dom.Node;
import org.w3c.dom.Element;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetInfo;

/**
* node for locale-charset-info tag
*
* @author Jerome Dochez
*/
public class LocaleCharsetInfoNode extends WebRuntimeNode {
    
    /**
     * Initialize the child handlers
     */
    public LocaleCharsetInfoNode() {
	
        registerElementHandler(new XMLElement(RuntimeTagNames.LOCALE_CHARSET_MAP), 
                               LocaleCharsetMapNode.class, "addLocaleCharsetMap");		       
    }
    
    public void startElement(XMLElement element, Attributes attributes) {
	if (element.getQName().equals(RuntimeTagNames.LOCALE_CHARSET_INFO)) {
            LocaleCharsetInfo info = (LocaleCharsetInfo) getDescriptor();
            for (int i=0; i<attributes.getLength();i++) {
                if (RuntimeTagNames.DEFAULT_LOCALE.equals( 
                    attributes.getQName(i))) {
                    info.setAttributeValue(LocaleCharsetInfo.DEFAULT_LOCALE, 
                        attributes.getValue(i));
                }
            }
        } else if (element.getQName().equals(
            RuntimeTagNames.PARAMETER_ENCODING)) {
	    LocaleCharsetInfo info = (LocaleCharsetInfo) getDescriptor();
            info.setParameterEncoding(true);
            for (int i=0; i<attributes.getLength();i++) {
                if (RuntimeTagNames.DEFAULT_CHARSET.equals(
                    attributes.getQName(i))) {
                    info.setAttributeValue(LocaleCharsetInfo.PARAMETER_ENCODING,
                        LocaleCharsetInfo.DEFAULT_CHARSET, 
                        attributes.getValue(i));
                }
                if (RuntimeTagNames.FORM_HINT_FIELD.equals(
                    attributes.getQName(i))) {
                    info.setAttributeValue(LocaleCharsetInfo.PARAMETER_ENCODING, 
                        LocaleCharsetInfo.FORM_HINT_FIELD,
                        attributes.getValue(i));
                }
            }
	} else super.startElement(element, attributes);
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, LocaleCharsetInfo descriptor) {
	
	Element locale = (Element) super.writeDescriptor(parent, nodeName, descriptor);
	
	// locale-charset-map+
	if (descriptor.sizeLocaleCharsetMap()>0) {
	    LocaleCharsetMapNode lcmn = new LocaleCharsetMapNode();
	    for (int i=0;i<descriptor.sizeLocaleCharsetMap();i++) {
		lcmn.writeDescriptor(locale, RuntimeTagNames.LOCALE_CHARSET_MAP, descriptor.getLocaleCharsetMap(i));
	    }
	}
	
	// <!ELEMENT parameter-encoding EMPTY>
	//<!ATTLIST parameter-encoding form-hint-field CDATA #IMPLIED
	//		     default-charset CDATA #IMPLIED>
	if (descriptor.isParameterEncoding()) {
	    Element parameter = (Element) appendChild(locale, RuntimeTagNames.PARAMETER_ENCODING);
	    
	    if (descriptor.getAttributeValue(LocaleCharsetInfo.PARAMETER_ENCODING, LocaleCharsetInfo.FORM_HINT_FIELD)!=null) {
	        setAttribute(parameter, RuntimeTagNames.FORM_HINT_FIELD, 
	    	(String) descriptor.getAttributeValue(LocaleCharsetInfo.PARAMETER_ENCODING, LocaleCharsetInfo.FORM_HINT_FIELD));
	    }
	    
	    
	    if (descriptor.getAttributeValue(LocaleCharsetInfo.PARAMETER_ENCODING, LocaleCharsetInfo.DEFAULT_CHARSET)!=null) {
	        setAttribute(parameter, RuntimeTagNames.DEFAULT_CHARSET, 
	    	(String) descriptor.getAttributeValue(LocaleCharsetInfo.PARAMETER_ENCODING, LocaleCharsetInfo.DEFAULT_CHARSET));
	    }
	}	    
	
	// default_locale
        if (descriptor.getAttributeValue(LocaleCharsetInfo.DEFAULT_LOCALE) != null) {
	    setAttribute(locale, RuntimeTagNames.DEFAULT_LOCALE, 
	        (String) descriptor.getAttributeValue(LocaleCharsetInfo.DEFAULT_LOCALE));
        }	
	return locale;
    }

}
