/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * WebTagNames.java
 *
 * Created on February 20, 2002, 5:15 PM
 */

package com.sun.enterprise.deployment.xml;

/**
 * Holds all tag names for the web application dtd
 *
 * @author  Jerome Dochez
 * @version 
 */
public interface WebTagNames extends TagNames {

    public static final String WEB_BUNDLE = "web-app";
    public static final String SERVLET = "servlet";    
    public static final String SERVLET_NAME = "servlet-name";
    public static final String SERVLET_CLASS = "servlet-class";
    public static final String JSP_FILENAME = "jsp-file";
    public static final String LOAD_ON_STARTUP = "load-on-startup";

    public static final String FILTER = "filter";
    public static final String FILTER_MAPPING = "filter-mapping";
    public static final String FILTER_CLASS = "filter-class";
    public static final String FILTER_NAME = "filter-name";
    public static final String DISPATCHER = "dispatcher";
  
    public static final String INIT_PARAM = "init-param";
    public static final String PARAM_NAME = "param-name";
    public static final String PARAM_VALUE = "param-value";    
    public static final String CONTEXT_PARAM = "context-param";
    
    public static final String SECURITY_CONSTRAINT = "security-constraint";
    public static final String WEB_RESOURCE_COLLECTION = "web-resource-collection";
    public static final String AUTH_CONSTRAINT = "auth-constraint";
    public static final String USERDATA_CONSTRAINT = "user-data-constraint";
    public static final String TRANSPORT_GUARANTEE = "transport-guarantee";
    public static final String WEB_RESOURCE_NAME = "web-resource-name";
    public static final String URL_PATTERN = "url-pattern";
    public static final String HTTP_METHOD = "http-method";    
    public static final String DISTRIBUTABLE = "distributable";    
    public static final String SESSION_CONFIG = "session-config";
    public static final String SESSION_TIMEOUT = "session-timeout";    
    public static final String WELCOME_FILE_LIST = "welcome-file-list";
    public static final String WELCOME_FILE = "welcome-file";
    public static final String SERVLET_MAPPING = "servlet-mapping";    
    
    public static final String MIME_MAPPING  = "mime-mapping";
    public static final String EXTENSION = "extension";
    public static final String MIME_TYPE  = "mime-type";    
    
    public static final String LISTENER = "listener";
    public static final String LISTENER_CLASS = "listener-class";    
    
    public static final String ERROR_PAGE = "error-page";
    public static final String ERROR_CODE = "error-code";
    public static final String EXCEPTION_TYPE = "exception-type";
    public static final String LOCATION = "location";    
    
    public static final String LOGIN_CONFIG = "login-config";
    public static final String AUTH_METHOD = "auth-method";
    public static final String REALM_NAME = "realm-name";
    public static final String FORM_LOGIN_CONFIG = "form-login-config";
    public static final String FORM_LOGIN_PAGE = "form-login-page";
    public static final String FORM_ERROR_PAGE = "form-error-page";    
    
    public static final String JSPCONFIG = "jsp-config";
    public static final String TAGLIB = "taglib";
    public static final String TAGLIB_URI = "taglib-uri";
    public static final String TAGLIB_LOCATION = "taglib-location";
    public static final String JSP_GROUP = "jsp-property-group";
    public static final String EL_IGNORED = "el-ignored";
    public static final String PAGE_ENCODING = "page-encoding";
    public static final String SCRIPTING_INVALID = "scripting-invalid";
    public static final String INCLUDE_PRELUDE = "include-prelude";
    public static final String INCLUDE_CODA = "include-coda";
    public static final String IS_XML = "is-xml";
    public static final String DEFERRED_SYNTAX_ALLOWED_AS_LITERAL = 
        "deferred-syntax-allowed-as-literal";
    public static final String TRIM_DIRECTIVE_WHITESPACES = 
        "trim-directive-whitespaces";
    
    public static final String LOCALE_ENCODING_MAPPING_LIST = "locale-encoding-mapping-list";
    public static final String LOCALE_ENCODING_MAPPING = "locale-encoding-mapping";
    public static final String LOCALE = "locale";
    public static final String ENCODING = "encoding";
}
