/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.util;

import  java.io.StringWriter;
import  java.io.PrintWriter;

/**
 * Utility class that is used for getting the stack trace for an
 * exception via a JNI upcall (used by the C++ JException class in
 * src/cpp/iws/netsite/j2ee/NSJavaUtil.*).
 */
public class JException {
    /**
     * Collect the stack trace from the exception for use by native methods
     * 
     * @param obj Throwable object
     * @return string, representing the stack trace
     */
    public static String getStackTrace(Throwable obj) {
        if (obj == null)
            return null;

        StringWriter traceBuf = new StringWriter();
        PrintWriter pw = new PrintWriter(traceBuf);
        
        obj.printStackTrace(pw);
        pw.close();
        
        return traceBuf.toString();
    }
}
