/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 package com.sun.enterprise.util;

import java.util.Properties;

//START OF IASRI 4660742
import java.util.logging.*;
import com.sun.logging.*;
//END OF IASRI 4660742


class NiceProperties extends Properties {

    // START OF IASRI 4660742
    static Logger _logger=LogDomains.getLogger(LogDomains.UTIL_LOGGER);
    // END OF IASRI 4660742


    // START OF IASRI 4679641
    // private static boolean debug = true;
    private static boolean debug = com.sun.enterprise.util.logging.Debug.enabled;
    // END OF IASRI 4679641
    
    public String getProperty(String key) {
	/** IASRI 4660742
	if (debug) System.out.println("Looking for key (" + key + ") in the props file, got (" + super.getProperty(key) + ")");
	**/
	// START OF IASRI 4660742
	if (debug && _logger.isLoggable(Level.FINE)) {
	   _logger.log(Level.FINE,"Looking for key (" + key + 
	   ") in the props file, got (" + super.getProperty(key) + ")");
  }
	// END OF IASRI 4660742
	return super.getProperty(key);
    }
}
