/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * SystemProps.java
 *
 * Created on October 2, 2001, 2:53 PM
 */

package com.sun.enterprise.util.diagnostics;

import java.util.*;
import com.sun.enterprise.util.StringUtils;

/**
 *
 * @author  bnevins
 * @version 
 */
public class SystemProps 
{
    public static List get() 
	{
		Properties p = System.getProperties();
		// these 2 lines woul;d be nice -- but it's case-sensitive...
		//Map sortedMap = new TreeMap(p);
		//Set sortedSet = sortedMap.entrySet();
		Set		set = p.entrySet();
		List	list = new ArrayList(set);
		Collections.sort(list, new Comparator()
		{
			public int compare(Object o1, Object o2)
			{
				Map.Entry me1 = (Map.Entry)o1;
				Map.Entry me2 = (Map.Entry)o2;
				
				return ((String)me1.getKey()).compareToIgnoreCase((String)me2.getKey());
			}
		});
		return list;
	}
	
	///////////////////////////////////////////////////////////////////////////
	
	public static String toStringStatic()
	{
		int				longestKey	= 0;
		List			list		= get();
		StringBuffer	sb			= new StringBuffer();

		for(Iterator it = list.iterator(); it.hasNext(); )
		{
			Map.Entry entry = (Map.Entry)it.next();
			int len = ((String)entry.getKey()).length();

			if(len > longestKey)
				longestKey = len;
		}

		longestKey += 1;

		for(Iterator it = list.iterator(); it.hasNext(); )
		{
			Map.Entry entry = (Map.Entry)it.next();
			sb.append(StringUtils.padRight((String)entry.getKey(), longestKey));
			sb.append("= ");
			sb.append((String)entry.getValue());
			sb.append("\n");
		}
		
		return sb.toString();
	}
	
	///////////////////////////////////////////////////////////////////////////
	
	private SystemProps()
	{
	}
	
	///////////////////////////////////////////////////////////////////////////
	
	public static void main(String[] args)
	{
		System.out.println(toStringStatic());
	}
}
