/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * NativeResults.java
 *
 * Created on April 14, 2003, 11:46 AM
 */

package com.sun.enterprise.util.io;
import java.util.*;
import java.util.logging.*;
import com.sun.enterprise.util.OS;

/**
 * Convert an integer error number returned from native code to a localized String
 * As of April, 2003 -- UNIX is the only supported OS.
 * @author  bnevins
 */

class NativeResults
{
	NativeResults(int id)
	{
		this.id = id;
		initStrings();
		setResultString();
		setResultException();
	}
	
	/**
	 * @return The localized String explanation of the error, or success.
	 */	
	String getResultString()
	{
		return resultString;
	}
	
	/**
	 * @return the NativeIOException -- suitable for throwing
	 */
	NativeIOException getResultException()
	{
		return exception;	// may be null!
	}
	
	///////////////////////////////////////////////////////////////////////////

	private void setResultString()
	{
		if(rb == null)
		{
			resultString = genericError + id;
			return;
		}
		
		try
		{
			resultString = rb.getString(errorKey + id);
			return;
		}
		catch(Throwable t)
		{
			// go into the next try block.  No need to nest it.
		}

		try
		{
			// note: the id is outside the parenthesis -- not a mistake...
			resultString =  rb.getString(unknownErrorKey) + id; 
			return;
		}
		catch(Throwable t)
		{
			resultString = genericError + id;
		}
	}
	
	///////////////////////////////////////////////////////////////////////////

	void setResultException()
	{
		if(id != 0)	// by definition -- an error!
			exception = new NativeIOException(resultString, id);
	}
	
	///////////////////////////////////////////////////////////////////////////

	private void initStrings()
	{
		try
		{
			rb = ResourceBundle.getBundle(RESOURCE_BUNDLE);
		}
		catch(Throwable t)
		{
			// any little error --> RuntimeException!!
			rb = null;
			logger.severe("Unable to get a ResourceBundle: " + RESOURCE_BUNDLE);
		}
		
		if(OS.isWindows())
			osString = "Windows";
		else
			osString = "UNIX";
		
		errorKey			= "enterprise_util." + osString + ".error.";
		unknownErrorKey		= errorKey + "unknown";
		genericError		= "UNKNOWN " + osString + " Error returned.  Errno =";
	}
	
	///////////////////////////////////////////////////////////////////////////

	private					Logger				logger				= IOLogger.getLogger();
	private					ResourceBundle		rb					= null;
	private static final	String				RESOURCE_BUNDLE		= "com.sun.logging.enterprise.system.util.LogStrings";
	private					String				errorKey;			// depends on OS
	private					String				unknownErrorKey;	// depends on OS
	private					String				genericError;		// depends on OS
	private					String				osString;			// depends on OS
	private					int					id;					// returned by native code
	private					String				resultString;
	private					NativeIOException	exception			= null;
	
	//////////////////////////////////////////////////////////////////////////
	
	public static void main(String[] args)
	{
		int errs[] = { 0, 1, 2, 4, 5, 13, 14, 20, 22, 30, 67, 78, 9999, 111, -2};

		for(int i = 0; i < errs.length; i++)
		{
			int id = errs[i];
			
			NativeResults nr = new NativeResults(id);
			String s = "ID: " + id + ",  ";
			
			if(nr.getResultException() == null)
				s += "NO ERROR, ";
			else
				s += "YES ERROR, ";
			
			s += nr.getResultString();
			
			System.out.println(s);
		}
	}
}

