/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.distributed;

import com.sun.ejb.spi.distributed.DistributedEJBService;
import com.sun.ejb.spi.distributed.DistributedEJBServiceFactory;

import com.sun.enterprise.admin.event.EjbTimerEvent;
import com.sun.enterprise.admin.event.EjbTimerEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.AdminEventListenerException;

/**
 * Implementation of Admin infrastructure EjbTimerEventListener interface
 * add @author: 
 * add @Date:
 * add @version: 
 */
public class AdminEJBTimerEventListenerImpl 
    extends EJBTimerBaseAction
    implements EjbTimerEventListener 
{
    protected static EjbTimerEventListener ejbTimerEventListener = 
        new AdminEJBTimerEventListenerImpl();

    static {
        AdminEventListenerRegistry.addEjbTimerEventListener( 
            ejbTimerEventListener );
    }

    public static EjbTimerEventListener getEjbTimerEventListener() {
        return ejbTimerEventListener;
    }

    private AdminEJBTimerEventListenerImpl() {
        super();
    }
 
    public int migrateTimer( EjbTimerEvent event, String fromServerId )
        throws AdminEventListenerException 
    {
        try {
            return migrateTimers( fromServerId  );
        } catch( Exception ex ) {
            AdminEventListenerException adminEx = new AdminEventListenerException();
            adminEx.initCause( ex );
            throw adminEx;
        }
    }

    public String[] listTimers(EjbTimerEvent event, String[] servers) 
        throws AdminEventListenerException 
    {
        try {
            return listTimers( servers );
        } catch( Exception ex ) {
            AdminEventListenerException adminEx = new AdminEventListenerException();
            adminEx.initCause( ex );
            throw adminEx;
        }
    }

} //AdminEJBTimerEventListenerImpl.java
