/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.sfsb.initialization;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.sun.logging.LogDomains;

import com.sun.ejb.base.sfsb.store.FileTxStoreManager;

import com.sun.ejb.spi.sfsb.store.SFSBTxStoreManager;

/**
 * Factory for creating SFSBTxStoreManager. SFSBTxStoreManager is
 *  responsible for checkpointing an Array of SFSBBeanState(s)
 *  (as a single transactional unit if possible)
 *
 * @author Mahesh Kannan
 */
public class SFSBTxStoreManagerFactory {

    private static Logger _logger =
        LogDomains.getLogger(LogDomains.EJB_LOGGER);
    
    protected static final String DEFAULT_EE_PACKAGE =
	"com.sun.ejb.ee.sfsb.store";        
    
    public static SFSBTxStoreManager createSFSBTxStoreManager(
	    String persistenceType)
    {
	if ("file".equalsIgnoreCase(persistenceType)) {
	    return new FileTxStoreManager();
	}

	try {
	    String className = createClassNameFrom(persistenceType);
	    return (SFSBTxStoreManager)
		    (Class.forName(className)).newInstance();
	} catch (ClassNotFoundException cnfEx) {
	    _logger.log(Level.FINE,
		"Exception while creating SFSBTxStoreManager for persistence "
		+ "type: " + persistenceType + ". Exception: " + cnfEx);
	} catch (Exception ex) {
	    _logger.log(Level.FINE,
		"Exception while creating SFSBTxStoreManager for "
		+ "persistence type: " + persistenceType, ex);
	}

	_logger.log(Level.WARNING, "Created FileTxStorManager for persistence"
		+ " type: " + persistenceType);

	return new FileTxStoreManager();
    }     
    
    /**
     *
     * @param persistenceType
     */     
    private static String createClassNameFrom(String persistenceType) {
        StringBuffer sbuf = new StringBuffer();
	sbuf.append(getEEPackage()).append(".") 
	    .append(camelCase(persistenceType))
	    .append("TxStoreManager");
        String classname = sbuf.toString();
        return classname;
    }    
    
    /**
     * this method strips out all non-alpha characters; camelCases the result
     *
     * @param inputString
     */     
    private static String camelCase(String inputString) {
        String strippedString = stripNonAlphas(inputString);
        String firstLetter = (strippedString.substring(0, 1)).toUpperCase();
        String remainingPart = 
            (strippedString.substring(1, strippedString.length())).toLowerCase();
        return firstLetter + remainingPart;
    }

    /**
     * this method strips out all non-alpha characters
     *
     * @param inputString
     */     
    private static String stripNonAlphas(String inputString) {
        StringBuffer sb = new StringBuffer(50);
        for(int i=0; i<inputString.length(); i++) {
            char nextChar = inputString.charAt(i);
            if(Character.isLetter(nextChar)) {
                sb.append(nextChar);
            }
        }
        return sb.toString();
    } 

    /**
     * return the path where the ee builders reside
     * although this method allows this to be configurable
     * via an property in server.xml we do not expose it
     * and it should not be re-configured
     *
     */    
    private static String getEEPackage() {
        return DEFAULT_EE_PACKAGE;
    }    
    
}
