/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.stats;

import javax.management.j2ee.statistics.StatefulSessionBeanStats;
import javax.management.j2ee.statistics.RangeStatistic;

import com.sun.enterprise.admin.monitor.stats.BoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableBoundedRangeStatisticImpl;

import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;

import java.util.logging.*;
import com.sun.enterprise.log.Log;
import com.sun.logging.*;

import com.sun.ejb.spi.stats.StatefulSessionBeanStatsProvider;

/**
 * A Class for providing stats for Stateful Container.
 *
 * @author Mahesh Kannan
 */

public class StatefulSessionBeanStatsImpl
    extends SessionBeanStatsImpl
    implements javax.management.j2ee.statistics.StatefulSessionBeanStats
{
    protected StatefulSessionBeanStatsProvider	sfsbDelegate;
    private MutableBoundedRangeStatisticImpl	passivateCountStat;

    public StatefulSessionBeanStatsImpl(StatefulSessionBeanStatsProvider delegate) {
	super(delegate, "javax.management.j2ee.statistics.StatefulSessionBeanStats");
	this.sfsbDelegate = delegate;

	initSessionStats();
    }

    protected void initSessionStats() {
	super.initSessionStats();
	passivateCountStat = new MutableBoundedRangeStatisticImpl(
	    new BoundedRangeStatisticImpl("PassiveCount"));
    }

    public RangeStatistic getPassiveCount() {
	passivateCountStat.setCount(sfsbDelegate.getPassiveCount());
	return (RangeStatistic) passivateCountStat.modifiableView();
    }

    protected int getMaxReadyCount() {
	return sfsbDelegate.getMaxCacheSize();
    }

    protected int getMinReadyCount() {
	return 0;
    }
}
