/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.containers;

import java.io.Serializable;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.TimerTask;

import javax.ejb.Timer;

import com.sun.logging.LogDomains;

/*
 * JDK timer task for timer expirations.  
 *
 * @author Kenneth Saks
 */
public class EJBTimerTask extends TimerTask {
    
    private Date timeout_;
    private TimerPrimaryKey timerId_;
    private EJBTimerService timerService_;

    private static Logger _logger = LogDomains.getLogger(LogDomains.EJB_LOGGER);

    EJBTimerTask(Date timeout, TimerPrimaryKey timerId, 
                 EJBTimerService timerService)
    { 
        timeout_ = timeout;
        timerId_ = timerId;
        timerService_ = timerService;
    }
    
    public void run() {
        // Delegate to Timer Service.
        timerService_.taskExpired(timerId_);
    }
    
    public Date getTimeout() {
        return timeout_;
    }

} 

