/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.portable;

import java.util.*;
import java.io.Serializable;

/**
 * This class is necessary because neither Vector nor Hashtable
 * return a Serializable Enumeration, which can be sent from the
 * EJB server back to the client.
 * This class must be available at the client too, and it could
 * be instantiated in another vendor's container.
 *
 */

public final class ObjrefEnumeration implements Enumeration, Serializable
{
    private int count=0;
    private ArrayList objrefs;

    // This is called only by the EJB container in the RI.
    public void add(Object obj)
    {
	if ( objrefs == null )
	    objrefs = new ArrayList();
	objrefs.add(obj);
    }

    public boolean hasMoreElements()
    {
	if ( objrefs == null )
	    return false;
	return count < objrefs.size();
    }

    public Object nextElement()
    {
	if ( objrefs != null ) {
	    synchronized (this) {
		if (count < objrefs.size()) {
		    return objrefs.get(count++);
		}
	    }
	}
	throw new NoSuchElementException("ObjrefEnumeration");
    }
}
