/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common;

//JDK imports
import java.io.Serializable;
import java.util.Date;

/**
	Holder class for IAS version & licensing info
*/
public class IASVersion implements Serializable
{
    /* javac 1.4 generated serialVersionUID */
	public static long serialVersionUID =  -6600350216728544568L;

    //VERSION
    private String m_ProductName;
	private String m_Version;
	private String m_MajorVersion;
	private String m_MinorVersion;
	private String m_BuildVersion;
    
    //LICENSE
    private String m_LicenseDescription;
    private String m_LicenseType;
    private Date   m_LicenseExpirationDate;
    private Date   m_LicenseStartDate;
    
        
    /** 
            Creates new Status.
    */
    public IASVersion(  String ProductName, 
                        String Version,
                        String MajorVersion,
                        String MinorVersion,
                        String BuildVersion,
                        String LicenseDescription,
                        String LicenseType,
                        Date   LicenseExpirationDate,
                        Date   LicenseStartDate )
    {
        m_ProductName   = ProductName;
        m_Version       = ProductName;
        m_MajorVersion  = ProductName;
        m_MinorVersion  = MinorVersion;
        m_BuildVersion  = BuildVersion;
        
        m_LicenseDescription = LicenseDescription;
        m_LicenseType = LicenseType;
        m_LicenseExpirationDate = LicenseExpirationDate;
        m_LicenseStartDate = LicenseStartDate;
    }

    public String getProductName() 
    {
        return m_ProductName;
    }
	public String getVersion() 
    {
        return m_Version;
    }
	public String getMajorVersion() 
    {
        return m_MajorVersion;
    }
	public String getMinorVersion() 
    {
        return m_MinorVersion;
    }
	public String getBuildVersion() 
    {
        return m_BuildVersion;
    }
    
    
    public String getLicenseDescription() 
    {
        return m_LicenseDescription;
    }
    public String getLicenseType() 
    {
        return m_LicenseType;
    }
    public Date   getLicenseExpirationDate() 
    {
        return m_LicenseExpirationDate;
    }
    public Date   getLicenseStartDate() 
    {
        return m_LicenseStartDate;
    }
}