/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common;

import java.io.Serializable;


/**
	Encapsulates a name/value pair.
	<p>
	The name of a Param is required to be a string, but its value may be
	any Serializable object.   Param does not alter value at any time. Thus
    Param is an immutable class.
	@author Lloyd Chambers
	@version 1.0
*/

public class Param implements Serializable
{
    public static long serialVersionUID = -6783475004108829145L;

	public String		mName;
	public Serializable	mValue;

	/**
		Constructs a new Param with name and value.
		<p>
		@param name		non-null String specifying parameter name
		@param value	any Serializable (may be null)
	 */
	public Param( String name, Serializable value )
	{
		//Assert.assert( (name != null), "null name" );

		mName	= name;
		mValue	= value;
	}

	/**
		Generates a string of the form: "name: value".
	 */
	public String toString()
	{
		if ( mValue != null )
		{
			return( mName + ": " + mValue );
		}
		return( mName + ": <null>" );
	}
        
        /**
            Defines the logical equality of Param instance with any other
            Object. Note that this method <strong> does not </strong> obey
            the general contract of the java.lang.Object.equls() method.
            An instance of Param is equal to other Object iff
            <li> it is also an instance of Param &&
            <li> it has the same name as that of this instance.
            It is clear that this method does not take into account the value
            of the Param.
         
            @param other instance of object to be compared
            @return boolean false if the objects are "equal" false otherwise
        */
        
        public boolean equals(Object other)
        {
            boolean isSame = false;
            if (other instanceof Param)
            {
                isSame = this.mName.equals(((Param)other).mName);
            }
            
            return isSame;
        }
        
        /**
            Generates the hashcode for this param. Since equals() method takes
            only name into account, this method also takes into account only
            the name.
            
            @return integer hashcode
        */
        public int hashCode()
        {
            return (mName.hashCode ());
        }
}