/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common.constant;

import com.sun.enterprise.admin.util.HostAndPort;

// i18n import 
import com.sun.enterprise.admin.util.SOMLocalStringsManager;

/**
 */
public final class AdminConstants
{
    public static final String  kAdminServletURI    = "web1/entry";
    public static final String  kHttpPrefix         = "http://";
  public static final String  kHttpsPrefix         = "https://";
    public static final int     kTypeWebModule      = 0;
    public static final int     kTypeEjbModule      = 1;

    public static final int     kDebugMode          = 0;
    public static final int     kNonDebugMode       = 1;

    public static final String CLIENT_VERSION       = "clientVersion";
    public static final String OBJECT_NAME          = "objectName";
    public static final String OPERATION_NAME       = "operationName";
    public static final String OPERATION_SIGNATURE  = "signature";
    public static final String OPERATION_PARAMS     = "params";
    public static final String EXCEPTION            = "exception";
    public static final String RETURN_VALUE         = "returnValue";
    public static final String ATTRIBUTE_NAME       = "attributeName";
    public static final String ATTRIBUTE            = "jmxAttribute";
    public static final String ATTRIBUTE_LIST       = "jmxAttributeList";
    public static final String ATTRIBUTE_NAMES      = "attributeNames";
    public static final String CLIENT_JAR           = "Client.jar";
    
    /** The name of the admin logger as registered in the LogDomains. */
    /* The reason to hardcode this here is that LogDomains class may
     * not be available for SOM or other parts of admin framework.
     * Make sure that the string is same as that in LogDomains.java.
    */
    public static final String kLoggerName = 
            "javax.enterprise.system.tools.admin";

	// i18n SOMLocalStringsManager
	private static SOMLocalStringsManager localizedStrMgr =
		SOMLocalStringsManager.getManager( AdminConstants.class );

    /* Some additional values for 8.0 PE */

    public static final String DOMAIN_ADMIN_GROUP_NAME = "asadmin";
    /* This should the same as the value of <group-name> in 
    com/sun/enterprise/admin/server/core/servlet/sun-web.xml */

    public static String getProtocolString(HostAndPort hp)
    {
        if (hp == null)
        {
			String msg = localizedStrMgr.getString( "admin.common.null_host_port" );
            throw new IllegalArgumentException( msg );
        }
        return ( (hp.isSecure() ? kHttpsPrefix : kHttpPrefix) + hp.toString() );
    }    
}
