/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common.constant;

/**
    Constants needed by the JMS administration handler.
 */
public final class JMSAdminGUI
{
    // JMS Object types
    public static final String JMS_OBJ_TYPE_TOPIC		= "javax.jms.Topic";
    public static final String JMS_OBJ_TYPE_QUEUE		= "javax.jms.Queue";
    public static final String JMS_OBJ_TYPE_QUEUE_CONN_FACTORY	= "javax.jms.QueueConnectionFactory";
    public static final String JMS_OBJ_TYPE_TOPIC_CONN_FACTORY	= "javax.jms.TopicConnectionFactory";

    // JMS destination types
    public static final String JMS_DEST_TYPE_TOPIC		= "Topic";
    public static final String JMS_DEST_TYPE_QUEUE		= "Queue";
    
    // JMS object valid attributes
    public static final String JMS_OBJ_ATTR_DEST                   = "imqDestinationName";
    public static final String JMS_OBJ_ATTR_CONN_FACTORY_HOST_NAME = "imqBrokerHostName";
    public static final String JMS_OBJ_ATTR_CONN_FACTORY_HOST_PORT = "imqBrokerHostPort";    
}
