/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.event;

/**
 * Dispatches an event to a target. Each server instance has an event
 * multicaster. This allows each server instance including the domain
 * admin server to send events bi-directionally. This works as a fat 
 * pipe or a bus between the server instances.
 *
 * <p> Event dispatcher only knows how to propagate an event between 
 * remote VMs. In other words, it is not responsible for making the 
 * actual delivery of the event with in the sever instance.
 *
 * @author Nazrul Islam
 * @since  JDK1.4
 */
public interface EventDispatcher {

    /**
     * Dispatches an event from one event multicaster to another based 
     * on the destination type in the event. If the destination is a cluster
     * or a group, it will send event to all running server instances in the
     * group.
     *
     * @param    event    notification event
     * @return   response from the listener
     */
    public AdminEventResult dispatch(AdminEvent event);
}
