/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEventListener;

/**
 * Listener interface to handle monitoring events.
 */
public interface MonitoringEventListener extends AdminEventListener {

    /**
     * Start monitoring on the component specified by the event. This method is
     * called whenever a monitoring event with action of
     * MonitoringEvent.START_MONITORING is received.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void startMonitoring(MonitoringEvent event)
             throws AdminEventListenerException;

    /**
     * Stop monitoring on the component specified by the event. This method is
     * called whenever a monitoring event with action of
     * MonitoringEvent.STOP_MONITORING is received.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void stopMonitoring(MonitoringEvent event)
             throws AdminEventListenerException;

    /**
     * Get monitoring data for the component specified in the event. This method
     * is called whenever a monitoring event with action of
     * MonitoringEvent.GET_MONITOR_DATA is received.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void getMonitoringData(MonitoringEvent event)
             throws AdminEventListenerException;

    /**
     * Set monitoring data for the component specified in the event. This method
     * is called whenever a monitoring event with action of
     * MonitoringEvent.SET_MONITOR_DATA is received.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void setMonitoringData(MonitoringEvent event)
             throws AdminEventListenerException;
    
    /**
     * Get list of monitorable(s) for the component specified in the event.
     * This method is called whenever a monitoring event with action of
     * MonitoringEvent.LIST_MONITORABLE is received.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void listMonitorable(MonitoringEvent event)
             throws AdminEventListenerException;
}
