/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.event;

import com.sun.logging.LogDomains;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventResult;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.admin.event.ElementChangeHelper;
import com.sun.enterprise.config.ConfigContext;

import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;

//i18n import
import com.sun.enterprise.util.i18n.StringManager;

/**
 * Restart event Helper - class providing support for informing
 * server(s) to set its(their) restart required state to true or false.
 *
 * @author: Satish Viswanatham
 */
public class RRPersistenceHelper{

    // i18n StringManager
    private static Logger _logger     = null;
    
    public RRPersistenceHelper() {
    }

    /**
     * Set the restart required status in the given instance name
     * if the result code is not success
     *
     * @param evt        Admin Event that is being sent 
     * @param result     Result of the Admin Event
     */
    public void setRestartRequiredForServer(AdminEvent event, 
        AdminEventResult result ) {

        if (AdminService.getAdminService() == null) {
            // This instance does not have admin service return null
            return;
        }

        String resCode = null;
        // the follows tests this is server or DAS
        try {
            if (result != null) {
                resCode = result.getResultCode();
            }
            if ((resCode == null) || 
                (!resCode.equals(AdminEventResult.SUCCESS)) ){

                if (event != null) {
                    setRestartRequired( event.getInstanceName(), true);
                }
            }
        } catch (Throwable t) {
           getLogger().log(Level.INFO,
                    "event.exception_during_restart_reset",t);
        }

    }

    /**
     * Set the restart required status in the given instance name
     *
     * @param inst       Local server instance name 
     * @param restart    boolen value for restart required flag
     */
    public void setRestartRequired(String inst, boolean restart) {

        try {
            RMIClient client = AdminChannel.getRMIClient(inst);
            if (client == null) {
                getLogger().log(Level.INFO, "event.rmi_client_not_found");
            } else {
                client.setRestartNeeded(restart); 
            }
        } catch (Throwable t) {
            getLogger().log(Level.INFO,
                "event.exception_during_restart_reset", t);
        }
    }
    
    /**
     * Set the restart required status in the current instance.
     * Server Runtime MBean calls this method to set the restart 
     * required state from DAS. 
     *
     * @param restart    boolen value for restart required flag
     */
    public void setRestartRequired(boolean restart) {
        String inst =  null;
        ServerContext svrCtx = ApplicationServer.getServerContext();
        if (svrCtx !=null) {
            inst = svrCtx.getInstanceName();
        }
        setRestartRequired(inst, restart);
    }

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger(LogDomains.ADMIN_LOGGER);
        }
        return _logger;
    }

}
