/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.event.http;

import com.sun.enterprise.admin.event.ElementChangeEvent;


/**
 * <pre>
 *      This event handles modifications to the following attributes of
 *      http-listener element.
 *          id, address, port, external-port, family, blocking-enabled, 
 *          acceptor-threads,  default-virtual-server, server-name,
 *          redirect-port, x-powered-by and enabled
 * </pre>
 *
 * @author: Satish Viswanatham
 */
public class HSHttpListenerEvent extends ElementChangeEvent {

    /**
     * Event type
     */
    public static final String eventType= HSHttpListenerEvent.class.getName();

    /**
     * Create a new HSHttpListenerEvent.
     *
     * @param instance name of the instance to which the event applies
     * @param action type of action - one of
     *              ElementChangeEvent.ACTION_ELEMENT_*
     *
     * @throws IllegalArgumentException if specified action is not valid
     */
    public HSHttpListenerEvent(String instance, int action, String name) {
        super(instance, HSHttpListenerEvent.eventType, action, name);
    }

}
