/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.admin.monitor.callflow.RequestType;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.callflow.Listener;

public class CallflowEventListener implements Listener {
    
    private  static TraceEventImpl traceImpl = null;
    private  static CallflowEventListener _instance = new CallflowEventListener();
    static CallflowEventListener getInstance() {
        return _instance;
    }
    
    // To give the call backs to the listener
    static synchronized void setTraceImpl(TraceEventImpl impl) {
        traceImpl = impl;
        // Switch.getSwitch().getCallFlowAgent().enableForNotifications(true);
    }
  
    static synchronized void register() {
        Switch.getSwitch().getCallFlowAgent().registerListener(getInstance());
    }

    static synchronized void unregister() {
        Switch.getSwitch().getCallFlowAgent().unregisterListener(getInstance());
    }
    
    public void requestStart(String requestId, 
                                    RequestType requestType,
                                    String callerIPAddress, String remoteUser) {
        traceImpl.requestStart(requestId, requestType, callerIPAddress,
                               System.nanoTime(), Thread.currentThread().toString());
    }

    public void requestEnd(String requestId) {
        traceImpl.requestEnd(requestId, System.nanoTime(), 
                                        Thread.currentThread().toString());
    }

    public void ejbMethodStart(String requestId, 
                       String methodName, String applicationName,
                       String moduleName, String componentName,
                       ComponentType componentType, String securityId,
                       String transactionId) {
        traceImpl.ejbMethodStart(requestId, methodName, componentType.toString(), applicationName,
                                 moduleName, componentName, transactionId, securityId,
                                 System.nanoTime(),Thread.currentThread().toString());
    }

    public void ejbMethodEnd(String requestId, Throwable exception) {
        traceImpl.ejbMethodEnd(requestId, exception, System.nanoTime(),
                                 Thread.currentThread().toString());
    }


    public void webMethodStart(String requestId, String methodName,
                               String applicationName, String moduleName,
                               String componentName, ComponentType componentType,
                               String callerPrincipal) {
        traceImpl.webMethodStart(requestId, methodName, applicationName, componentType.toString(), 
                                 componentName, callerPrincipal, System.nanoTime(), 
                                 Thread.currentThread().toString());
    }

    public void webMethodEnd(String requestId, Throwable exception) {
        traceImpl.webMethodEnd(requestId,exception, System.nanoTime(), 
                                 Thread.currentThread().toString());
    }

}
