/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EventBuilder.java
 *
 */

package com.sun.enterprise.admin.selfmanagement.event;

import java.util.concurrent.ConcurrentHashMap;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Hashtable;

/**
 *
 * @author Sun Micro Systems, Inc
 */
public class EventBuilder {
    
    private static final EventBuilder instance = new EventBuilder( );
    
    private static ConcurrentHashMap<String,EventAbstractFactory>
            eventFactoryMap = new ConcurrentHashMap<String,EventAbstractFactory>(10, 0.75f, 2);
    private boolean initialized = false;
    
    protected static StringManager sm = StringManager.getManager(EventBuilder.class);
    
    /** Creates a new instance of EventBuilder */
    private EventBuilder() {
    }
    
    public static EventBuilder getInstance( ) {
        return instance;
    }
    
    public synchronized void addEventFactory(String eventType, EventAbstractFactory factory) {
        if ( eventFactoryMap.get( eventType ) == null)
            eventFactoryMap.put(eventType, factory);
    }
    
    /**
     * Given an event type, an event is returned. As of now, supported events
     * are "log","monitor","lifecycle","notification" and "timer" in PE and
     * in addition "gms" in EE.
     * @param eventType one of the supported event types
     * @param properties properties associated with the event
     * @param description event description
     * @return Event constructed event
     */
    public Event getEvent( String eventType,
            ElementProperty[] properties, String description ) {
        if (!initialized) {
            initialized = true;
            LogEventFactory.getInstance();
            NotificationEventFactory.getInstance();
            LifeCycleEventFactory.getInstance();
            MonitorEventFactory.getInstance();
            TimerEventFactory.getInstance();
            TraceEventFactory.getInstance();
        }
        EventAbstractFactory factory =
                eventFactoryMap.get( eventType );
        
        if( factory == null ) {
            throw new IllegalArgumentException(
                    sm.getString("selfmgmt_event.unknown_event_type",eventType));
        }
        
        return factory.instrumentEvent(properties, description);
    }

    public Event  getEvent( String eventType, String description,
                  Hashtable attributes, ElementProperty[] properties) {
        return getEvent(eventType,properties, description);
    }
    
    
}
