/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LifeCycleEventFactory.java
 *
 */

package com.sun.enterprise.admin.selfmanagement.event;


import javax.management.NotificationEmitter;
import javax.management.MBeanServer;

import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.admin.selfmanagement.configuration.JavaBeanConfigurator;
import java.util.logging.Level;
import static com.sun.enterprise.admin.selfmanagement.event.ManagementRuleConstants.*;

/**
 *
 * @author Sun Micro Systems, Inc
 */

public class LifeCycleEventFactory extends EventAbstractFactory {
    
    private LifeCycleEventFactory( ) {
        super();
        EventBuilder.getInstance().addEventFactory(EVENT_LIFECYCLE, this);
        try {
            LifeCycleImpl impl = (LifeCycleImpl) getMBeanServer().instantiate(
                    "com.sun.enterprise.admin.selfmanagement.event.LifeCycleImpl");
            getMBeanServer().registerMBean(impl,LifeCycleEvent.getLifeCycleImplObjectName());
        } catch (javax.management.ReflectionException rex) {
            _logger.log(Level.WARNING,"smgt.internal_error", rex);
        } catch (javax.management.InstanceAlreadyExistsException iex) {
            _logger.log(Level.WARNING,"smgt.internal_error", iex);
        } catch (Exception ex) {
            _logger.log(Level.WARNING,"smgt.internal_error", ex);
            
        }
    }
    
    public Event instrumentEvent(
            ElementProperty[] properties, String description ) {
        String eventName = null;
        for( int i = 0; i < properties.length; i++ ){
            ElementProperty property = properties[i];
            String propertyName = property.getName( ).toLowerCase( );
            if( propertyName.equals(PROPERTY_LIFECYCLE_NAME)) {
                eventName = "lifecycle." + property.getValue( ).toLowerCase( );
                if (!LifeCycleEvent.isValidType(eventName))
                    throw new IllegalArgumentException(
                            sm.getString("name","selfmgmt_event.invalid_event_property","lifecycle"));
            }
        }
        return new LifeCycleEvent(eventName, new LifeCycleNotificationFilter(eventName), description);
    }
    
    static LifeCycleEventFactory getInstance() {
        return instance;
    }
    private static LifeCycleEventFactory instance = new LifeCycleEventFactory();
}
