/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core;
import com.sun.enterprise.config.serverbeans.Mbean;
import java.lang.reflect.Constructor;
import javax.management.MBeanServer;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.util.List;

class CustomMBeanRegistrationHelper {
    private final MBeanServer mbs;
    private final ConfigContext cc;
    private final String myName;
    private final CustomMBeanRegistration cmr;
    CustomMBeanRegistrationHelper(final MBeanServer mbs, final ConfigContext cc) throws Exception {
        this.mbs     = mbs;
        this.cc     = cc;
        myName      = System.getProperty(SystemPropertyConstants.SERVER_NAME);
        cmr         = mbeanRegistrationFactory();
    }
    
    void registerMBeans() throws Exception {
        final List<Mbean> m2r = getMBeans2Register();
        cmr.registerMBeans(m2r);
    }
    
    ///// private methods /////
    private CustomMBeanRegistration mbeanRegistrationFactory() throws Exception {
        final String CUSTOM_REGRISTRATION_IMPL_CLASS = "com.sun.enterprise.admin.mbeans.custom.loading.CustomMBeanRegistrationImpl";
        final Class c           = Class.forName(CUSTOM_REGRISTRATION_IMPL_CLASS);
        final Class[] pts       = new Class[]{javax.management.MBeanServer.class};
        final Constructor ctor  = c.getConstructor(pts);
        final Object[] aps      = new Object[]{mbs};
        return ( (CustomMBeanRegistration) ctor.newInstance(aps) );
    }
    
    private List<Mbean> getMBeans2Register() throws Exception {
        return ( ServerBeansFactory.getFullyEnabledUserDefinedMBeans(cc, myName) );
    }
    ///// private methods /////
}