/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appclient.jws;

import java.io.File;
import java.net.URI;

/**
 *Represents content to be served back to Java Web Start on users' systems.
 *
 * @author tjquinn
 */
  
public class AppserverStaticContent extends StaticContent {

    /** records whether this particular static content instance represents a signed jar or not */
    private boolean isSigned = false;
    
    /**
     *Returns a new instance of the AppserverStaticContent class.
     *@param origin the owning ContentOrigin
     *@param contentKey content key for storing and retrieving the content
     *@param path path within the content's subcategory of this content
     *@param file File object for the physical file corresponding to this static content
     *@param installRootURI the app server's installation root URI
     *@param isMainJarFile whether this appserver static content should be flagged as the main jar in a JNLP document
     *@return new StaticContent object
     */
    public AppserverStaticContent(ContentOrigin origin, String contentKey, String path, File file, URI installRootURI, boolean isMainJarFile) {
        super(origin, contentKey, path, file, installRootURI, isMainJarFile);
    }

    /**
     *Returns a new instance of the AppserverStaticContent class that is not a main jar.
     *@param origin the owning ContentOrigin for the new content
     *@param contentKey content key for storing and retrieving the content
     *@param path path within the content's subcategory of this content
     *@param file File object for the physical file corresponding to this static content
     *@param installRootURI installation URI for the app server
     *@return new StaticContent object
     */
    public AppserverStaticContent(ContentOrigin origin, String contentKey, String path, File file, URI installRootURI) {
        this(origin, contentKey, path, file, installRootURI, false);
    }

    /**
     *Returns a new instance of the AppserverStaticContent class that is not a main jar.
     *@param origin owning ContentOrigin of the new content
     *@param content key prefix for storing and retrieving the content
     *@param path within the content's subcategory of this content
     *@param file object for the physical file corresponding to this static content
     *@param the app server's installation root URI
     *@param whether the content is a jar that contains the main class we want Java Web Start to run
     *@param whether the content is a signed jar or not
     *@return new StaticContent object
     */
    public AppserverStaticContent(ContentOrigin origin, String contentKey, String path, File file, URI installRootURI, boolean isMainJarFile, boolean isSigned) {
        this(origin, contentKey, path, file, installRootURI, isMainJarFile);
        this.isSigned = isSigned;
    }
    
    /**
     *Returns the path for this content.
     *<p>
     *For appserver static content, the content key and the path are the same.
     */
    public String getPath() {
        return getContentKey();
    }
}
