/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors;

import javax.resource.spi.ConnectionManager;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

/* Authors : Binod P G, Aditya Gore
 *
*/

public class ConnectionManagerFactory {
    
    
        public static ConnectionManager getAvailableConnectionManager(
            String poolName, boolean forceNoLazyAssoc) 
            throws ConnectorRuntimeException 
        {
               
                Logger _logger = LogDomains.getLogger( LogDomains.RSR_LOGGER );
                
                ConnectorRegistry registry = ConnectorRegistry.getInstance();
                PoolMetaData pmd = registry.getPoolMetaData( poolName );
                boolean isLazyEnlist = pmd.isLazyEnlistable();
                boolean isLazyAssoc = pmd.isLazyAssociatable();
                
                ConnectionManagerImpl mgr = null;

                if ( isLazyAssoc && !forceNoLazyAssoc ) {
                    if (_logger.isLoggable( Level.FINE) ) { 
                        _logger.fine( 
                            "@@@@ Creating LazyAssociatableConnectionManager");
                    }
		    mgr = new LazyAssociatableConnectionManagerImpl(poolName);
                } else if ( isLazyEnlist ) {
                    if (_logger.isLoggable( Level.FINE) ) { 
                        _logger.fine( 
                            "@@@@ Creating LazyEnlistableConnectionManager");
                    }
		    mgr = new LazyEnlistableConnectionManagerImpl(poolName);
                } else {
                    if (_logger.isLoggable( Level.FINE) ) { 
                        _logger.fine( 
                            "@@@@ Creating plain ConnectionManager");
                    }
		    mgr = new ConnectionManagerImpl(poolName);
                }
		return mgr;
	}

}
