/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
  * DeploymentStatusImplWithError.java
  *
  * Created on August 13, 2004, 8:54 AM
  */

package com.sun.enterprise.deployapi;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.shared.CommandType;

/**
  *Simple implementation of DeploymentStatus intended to describe an exception that
  *occurred during a DeploymentManager method invocation.
  * @author  tjquinn
  */
public class DeploymentStatusImplWithError extends DeploymentStatusImpl {
    
    /** Records the error, if any, associated with this status object */
    private Throwable cause = null;
    
    private CommandType commandType = null;
    
    /** Creates a new instance of DeploymentStatusImplWithError */
    public DeploymentStatusImplWithError() {
    }
    
    /** Creates a new instance of DeploymentStatusImplWithError */
    public DeploymentStatusImplWithError(CommandType commandType, Throwable cause) {
        super();
        initCause(cause);
        setState(StateType.FAILED);
        setCommand(commandType);
    }
    
    /**
     *Assigns the cause for this status.
     *@param Throwable that describes the error to be reported
     */
    public void initCause(Throwable cause) {
        this.cause = cause;
        setMessage(cause.getMessage());
    }
    
    /**
     *Returns the cause for this status.
     *@return Throwable that describes the error associated with this status
     */
    public Throwable getCause() {
        return cause;
    }
    
    /**
     *Displays the status as a string, including stack trace information if error is present.
     *@return String describing the status, including stack trace info from the error (if present).
     */
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        if (cause != null) {
            String lineSep = System.getProperty("line.separator");
            result.append(lineSep).append("Cause: ");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            cause.printStackTrace(pw);
            pw.close();
            result.append(baos.toString());
        }
        return result.toString();
    }
}
