/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
  * ProgressObjectIimplWithError.java
  *
  * Created on August 13, 2004, 9:53 AM
  */

package com.sun.enterprise.deployapi;

import java.util.Vector;
import java.util.Iterator;

import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.shared.StateType;

/**
  *Implements a progress object primarily intended to report an error during a DeploymentManager
  *method invocation.
  * @author  tjquinn
  */
public class SimpleProgressObjectImpl implements ProgressObject {
    
    /** Records registered listeners */
    private Vector listeners = new Vector();

    /**
     *Records all events delivered so late-registering listeners will be informed of all past events
     *as well as future ones.
     */
    protected Vector deliveredEvents = new Vector();
    
    /** Records the deployment status.  Normally of type DeploymentStatusWithError */
    private DeploymentStatus deploymentStatus = null;
    
    /** Creates a new instance of ProgressObjectIimplWithError */
    public SimpleProgressObjectImpl(DeploymentStatus deploymentStatus) {
        this.deploymentStatus = deploymentStatus;
    }

    /**
     *Registers a listener for progress events.
     *@param new progress listener
     */
    public void addProgressListener(javax.enterprise.deploy.spi.status.ProgressListener progressListener) {
	synchronized (listeners) {
            listeners.add(progressListener);
	    if (deliveredEvents.size() > 0) {
	        for (Iterator i = deliveredEvents.iterator(); i.hasNext();) {
		    progressListener.handleProgressEvent((ProgressEvent)i.next());
	        }
	    }
	}
    }    
    
    public void cancel() throws javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException {
        throw new OperationUnsupportedException("cancel not supported");
    }
    
    public javax.enterprise.deploy.spi.status.ClientConfiguration getClientConfiguration(javax.enterprise.deploy.spi.TargetModuleID targetModuleID) {
        return null;
    }
    
    public javax.enterprise.deploy.spi.status.DeploymentStatus getDeploymentStatus() {
        return deploymentStatus;
    }
    
    public javax.enterprise.deploy.spi.TargetModuleID[] getResultTargetModuleIDs() {
        return new javax.enterprise.deploy.spi.TargetModuleID[0];
    }
    
    public boolean isCancelSupported() {
        return false;
    }
    
    public boolean isStopSupported() {
        return false;
    }

    /**
     *Unregister a previously-registered event listener.
     *@param the listener to unregister
     */
    public void removeProgressListener(javax.enterprise.deploy.spi.status.ProgressListener progressListener) {
	synchronized (listeners) {
            listeners.remove(progressListener);
	}
    }
    
    public void stop() throws javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException {
        throw new OperationUnsupportedException("stop not supported");
    }
    
    /**
     * Notifies all listeners that have registered interest for ProgressEvent notification. 
     */
    protected void fireProgressEvent(ProgressEvent progressEvent) {
	Vector currentListeners = null;
        synchronized (listeners) {
            currentListeners = (Vector) listeners.clone();
            deliveredEvents.add(progressEvent);
        }

        for (Iterator listenersItr = currentListeners.iterator(); listenersItr.hasNext();) {
            ((ProgressListener)listenersItr.next()).handleProgressEvent(progressEvent);
        }
        currentListeners = null;
    }


}
