/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.client;

import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.enterprise.deployapi.ProgressObjectImpl;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.util.i18n.StringManager;

import java.io.IOException;
import java.util.ArrayList;

import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;

public class ChangeStateAction extends ProgressObjectImpl {

    public ChangeStateAction(SunTarget[] targets) {
        super(targets);
    }

    public void run() {
        ConnectionSource dasConnection= (ConnectionSource) args[0];
        SunTarget[] targets = (SunTarget[]) args[1];
        String moduleID = (String) args[2];
        CommandType newState = (CommandType) args[3];
        SunTarget domain = (SunTarget) args[4];
        StringManager localStrings = StringManager.getManager(getClass());

        ModuleType moduleType;
        try {
            moduleType = DeploymentClientUtils.getModuleType(
                dasConnection.getExistingMBeanServerConnection(), moduleID);
        } catch (Throwable ioex) {
            finalDeploymentStatus.setStageException(ioex);
            setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.unrecognized_module_type", moduleID ,ioex.getMessage()),
                        domain);
            return;
        }
        
        boolean state = false;
        String action = "Disable";
        if (CommandType.START.equals(newState)) {
            state = true;
            action = "Enable";
        }

        // the target module ids in which the operation was successful
        ArrayList resultTargetModuleIDs = new ArrayList();             

        for(int i=0; i<targets.length; i++) {
            DeploymentStatus stat = new DeploymentStatus();
            stat.setStageDescription(
                localStrings.getString("enterprise.deployment.client.state_change_desc", action, moduleID));
            try {
                DeploymentClientUtils.changeStateOfModule(dasConnection.getExistingMBeanServerConnection(), moduleID,
                                ((moduleType == null) ? null : moduleType.toString()), targets[i], state);
                stat.setStageStatus(DeploymentStatus.SUCCESS);
                stat.setStageStatusMessage(
                    localStrings.getString("enterprise.deployment.client.state_change_success", action, moduleID));
            } catch (Throwable ex) {
                stat.setStageException(ex);
                stat.setStageStatus(DeploymentStatus.FAILURE);
                stat.setStageStatusMessage(ex.getMessage());
            }
            if(!checkStatusAndAddStage(targets[i], null, 
                            localStrings.getString("enterprise.deployment.client.change_state", action, moduleID, targets[i].getName()), dasConnection, stat, state)) {
                return;
            }
            resultTargetModuleIDs.add(new SunTargetModuleID(moduleID, targets[i]));
        }

        // initialize the instance variable targetModuleIDs using 
        // the successful module ids
        this.targetModuleIDs = new TargetModuleID[resultTargetModuleIDs.size()];
        this.targetModuleIDs = 
            (TargetModuleID[])resultTargetModuleIDs.toArray(this.targetModuleIDs);

        setupForNormalExit(localStrings.getString("enterprise.deployment.client.change_state_all", action), domain);
    }
}
