/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.client;

/**
 * This factory is for getting the implementation instance of DeploymentFacilityImpl
 */
public class DeploymentFacilityFactory {

    private static final String LOCAL_DF = 
        "com.sun.enterprise.deployment.client.local.LocalDeploymentFacilityImpl";

    public static DeploymentFacility getDeploymentFacility() {
        return new DeploymentFacilityImpl();
    }
    
    public static DeploymentFacility getLocalDeploymentFacility() {
        DeploymentFacility df = null;
        try {
            df = (DeploymentFacility) Class.forName(LOCAL_DF).newInstance();
        } catch (Exception ex) {
            //@@@ log this
            ex.printStackTrace();
            return null;
        }
        ServerConnectionIdentifier sid = new ServerConnectionIdentifier();
        sid.setHostName("localhost");
        df.connect(sid);
        return df;
    }
}
