/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.client;

import javax.enterprise.deploy.spi.status.ProgressObject;

import com.sun.enterprise.deployment.backend.DeploymentStatus;

/**
 * This interface extends the JSR88 interface for providing 
 * deployment operations feedback and progress information. 
 * In particular, it allows to retrieve the complete JES 
 * deployment status object with all the phases information.
 *
 * @author Jerome Dochez
 */
public interface JESProgressObject extends ProgressObject {
    
    /** 
     * Once the progress object has reached a completed or 
     * failed state, this API will permit to retrieve the 
     * JES status information for the deployment
     * @return the deployment status
     */
    DeploymentStatus getCompletedStatus();
}
