/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ApplicationStopPhase.java
 *
 * Created on May 20, 2003, 3:19 PM
 * @author  sandhyae
 * <BR> <I>$Source: /cvs/glassfish/appserv-core/src/java/com/sun/enterprise/deployment/phasing/ApplicationStopPhase.java,v $
 *
 */

package com.sun.enterprise.deployment.phasing;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.MBeanException;

import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventType;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.admin.event.BaseDeployEvent;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.server.core.AdminNotificationHelper;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.server.Constants;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Phase that is responsible to send stop events when an application is undeployed or
 * disassociated
 * @author  Sandhya E
 */
public class ApplicationStopPhase extends DeploymentPhase {
    
    /** Deployment Logger object for this class */
    public static final Logger sLogger = DeploymentLogger.get();
    
    /** string manager */
    private static StringManager localStrings =
        StringManager.getManager( ApplicationStopPhase.class );
    
    /**
     * Creates a new instance of Class 
     * @param deploymentCtx DeploymentContext object
     */
    public ApplicationStopPhase(DeploymentContext deploymentCtx)
    {
        this.deploymentCtx = deploymentCtx;
        this.name = APP_STOP;
    }
    
    /** 
     * Sends stop events to the required target 
     * @param req DeploymentRequest object
     * @param phaseCtx the DeploymentPhaseContext object     
     */
    public void runPhase(DeploymentPhaseContext phaseCtx)
    {
        String type = null;
        
        DeploymentRequest req = phaseCtx.getDeploymentRequest();

        DeploymentTarget target = (DeploymentTarget)req.getTarget(); 
        DeploymentStatus status = phaseCtx.getDeploymentStatus();

        int loadUnloadAction = Constants.UNLOAD_ALL;

        if(!req.isApplication())
        {         
            type = DeploymentServiceUtils.getModuleTypeString(req.getType());
        } else {
            Application app = DeploymentServiceUtils.getInstanceManager(
               DeployableObjectType.APP).getRegisteredDescriptor(req.getName());

            if ( (app != null) && (app.getRarComponentCount() != 0) ) {
                loadUnloadAction = Constants.UNLOAD_REST;
            }
        }
        
        prePhaseNotify(getPrePhaseEvent(req));
        
        boolean success;
        try {
            // send this event to unload non-rar standalone module
            // or to unload the non-rar submodules of embedded rar
            if (! req.isConnectorModule()) {
                success = target.sendStopEvent(req.getActionCode(), req.getName(), type, req.getCascade(), req.isForced(), loadUnloadAction);
            } else {
                status.setStageStatus(DeploymentStatus.SUCCESS);
                return;
            }
        } catch(DeploymentTargetException dte) {
            status.setStageStatus(DeploymentStatus.FAILURE);
            if (dte.getCause()!=null) {
                status.setStageException(dte.getCause());
                status.setStageStatusMessage(dte.getMessage());
            }
            return;
        }
        if (success) {
            status.setStageStatus(DeploymentStatus.SUCCESS);
        } else {
            status.setStageStatus(DeploymentStatus.FAILURE);
            status.setStageStatusMessage("Application failed to stop");
        }            
        
        postPhaseNotify(getPostPhaseEvent(req));
        
        // if any exception is thrown. we let the stack unroll, it 
        // will be processed in the DeploymentService.
    }
    
    /**
     * Event that will be broadcasted at the start of the phase
     * @param req Deployment request object
     * @return DeploymentEvent
     */
    protected DeploymentEvent getPrePhaseEvent(DeploymentRequest req) 
    {
        return new DeploymentEvent(DeploymentEventType.PRE_APP_STOP, new DeploymentEventInfo(req));
    }
    
    /**
     * Event that will be broadcasted at the end of the phase
     * @param req Deployment request object
     * @return DeploymentEvent
     */
    protected DeploymentEvent getPostPhaseEvent(DeploymentRequest req) 
    {
        return new DeploymentEvent(DeploymentEventType.POST_APP_STOP,new DeploymentEventInfo(req) );
    }

}
