/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.pluggable;

import com.sun.enterprise.admin.event.DeployEventListenerHelper;
import com.sun.enterprise.admin.event.PEDeployEventListenerHelper;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.deployment.phasing.DeploymentService;
import com.sun.enterprise.deployment.phasing.DeploymentTargetFactory;
import com.sun.enterprise.deployment.phasing.DeploymentTargetFactoryPEImpl;
import com.sun.enterprise.deployment.phasing.PEDeploymentService;

/**
 * Pluggable feature factory for PE deployment. 
 * @author  Nazrul Islam
 */
public class PEDeploymentFactory implements DeploymentFactory {    

    /**
     * @return Returns the appropriate implementation for DeploymentService
     *
     * @param  configContext config context object
     */
    public DeploymentService createDeploymentService(
            ConfigContext configContext) {
        return new PEDeploymentService(configContext);
    }

    /**
     * @return Returns the appropriate implementation for DeployEventListenerHelper
     *
     */
    public DeployEventListenerHelper createDeployEventListenerHelper() {
        return new PEDeployEventListenerHelper();
    }

    /**
     * @return Returns the appropriate implementation for DeploymentTargetFactory
     */
    public DeploymentTargetFactory createDeploymentTargetFactory() {
        return new DeploymentTargetFactoryPEImpl();
    }
}
