/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.PEHarvester;
import com.sun.enterprise.diagnostics.report.html.HTMLReportWriter;
import java.util.Map;

/**
 *
 * @author mu125243
 */
public class PEBackendObjectFactory extends SingleInstanceObjectFactory {
    
    /** Creates a new instance of PEBackendObjectFactory */
    public PEBackendObjectFactory(Map map) {
        super(map);
    }
    
    public Collector createHarvester() throws DiagnosticException {
        return new PEHarvester(getReportConfig());
    }
    
    public HTMLReportWriter createHTMLReportWriter() 
    throws DiagnosticException {
        return new HTMLReportWriter(getReportConfig());
    }
    
    public TargetResolver createTargetResolver(boolean local) 
    throws DiagnosticException {
         if(options != null) {
            if(local)
                return new PELocalTargetResolver(options.getTargetName(), 
                    options.getTargetDir(), local);
            else
                return new PERemoteTargetResolver(options.getTargetName(), 
                    options.getTargetDir(), local);
        }
        throw new DiagnosticException("Null input for resolving target");
    }

    public ReportGenerator createReportGenerator(ReportConfig config,
            Collector harvester,HTMLReportWriter reportWriter)
            throws DiagnosticException{
        return new ReportGenerator(config, harvester, reportWriter);
    }

}
