/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.collect;

import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.BufferedReader;
import java.io.FileReader;
import com.sun.enterprise.diagnostics.Data;

/**
 *
 * @author Manisha Umbarje
 */
public class FileData extends WritableDataImpl {
    
    /** Creates a new instance of FileData */
    public FileData(String fileName, String type) {
        super(fileName, type);
    }

    /**
     * This method must be called before using other methods such as getValues.
     * Otherwise those methods return null.
     */
    public void populateDataObject() {
        if (source != null) {
            try {
                String fileEntry;
                BufferedReader fileReader = 
                        new BufferedReader(new FileReader(source));
                while((fileEntry = fileReader.readLine()) != null) {
                    values.add(fileEntry);
                }
                
            } catch(FileNotFoundException fnfe) {
                
            } catch(IOException ioe) {
                
            }
        }
    }
   
}
