/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.util;

import java.util.Calendar;
import java.util.Date;
/**
 *
 * @author mu125243
 */
public class UniqueNameGenerator {
    
    private static final String AM = "AM";
    private static final String PM = "PM";
    private static final char SEPARATOR = '-';
    private static final char DATE_SEPARATOR = '_';
    private static final String REPORT_JAR = "report.jar";
    
    /** Creates a new instance of UniqueNameGenerator */
    public UniqueNameGenerator() {
    }
    
    /**
     * @param defaultDir directory in which report is stored
     * @name name of the target for which report is being generated
     * @return name of diagnostic report
     */
    public static String getName(String target) {
        Date dateObj = new Date();
        Calendar calendar = Calendar.getInstance();
        String am_pm = calendar.get(Calendar.AM_PM) == 0? AM : PM;
        int month =  calendar.get(Calendar.MONTH) + 1;
        String dateValue =  "" + month +
                calendar.get(Calendar.DAY_OF_MONTH) + 
                calendar.get(Calendar.YEAR);
        String dateTime = ""+calendar.get(Calendar.HOUR_OF_DAY) + 
               SEPARATOR + calendar.get(Calendar.MINUTE) + am_pm;
        String fileName =   target + SEPARATOR +
                dateValue + DATE_SEPARATOR + dateTime + SEPARATOR + REPORT_JAR;
 
        return fileName;
    }
}
