/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.iiop;

import javax.management.j2ee.statistics.Statistic;

import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;

/**
 * This is the common base class for the collection of statistics
 * for the threadpool and orb connection manager.
 *
 * @author Pramod Gopinath
 */

public class ORBCommonStatsImpl {

    private GenericStatsImpl genericStatsDelegate;

    protected ORBCommonStatsImpl() {
    }

    protected void initialize(String statInterfaceName) {
        try {
            genericStatsDelegate =  new GenericStatsImpl(statInterfaceName, this);
        } catch(ClassNotFoundException cnfEx) {
            throw new RuntimeException(statInterfaceName + " not found", cnfEx);
        }
    }

    public Statistic getStatistic(String statName) {
        return genericStatsDelegate.getStatistic(statName);
    }

    public String[] getStatisticNames() {
        return genericStatsDelegate.getStatisticNames();
    }

    public Statistic[] getStatistics() {
        return genericStatsDelegate.getStatistics();
    }

}
