/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.instance;

import com.sun.enterprise.config.ConfigException;


/**
 * A factory to create instance specific objects. 
 */
public class InstanceFactory {

   /**
    * Returns a AppsManager object which provides convenience fuctions 
    * to read and save data related to the specified server id. 
    * 
    * @return  a AppsManager for a given configuration context
    */
    public static AppsManager createAppsManager(String serverId) 
	throws ConfigException
    {
	InstanceEnvironment env = new InstanceEnvironment(serverId);
	return new AppsManager(env);
    }

    /**
     * Returns a AppsManager object which provides convenience fuctions 
     * to read and save data related to the specified server id. 
     * 
     * @return  a AppsManager for a given configuration context
     */
    public static AppsManager createAppsManager(String installRoot, 
	    String serverId) throws ConfigException
    {
        return createAppsManager(installRoot, serverId, true);
    }

    /**
     * Returns a AppsManager object which provides convenience fuctions 
     * to read and save data related to the specified server id. 
     * 
     * @return  a AppsManager for a given configuration context
     */
    public static AppsManager createAppsManager(String installRoot, 
	    String serverId, boolean useBackupServerXml) throws ConfigException
    {
	InstanceEnvironment env = new InstanceEnvironment(installRoot,serverId);
	return new AppsManager(env, useBackupServerXml);
    }

    /**
     * Returns a manager object for the J2EE applicatoins. 
     * AppsManager object provides convenience fuctions 
     * to read and save data related to the given server instance. 
     *
     * @param    env    environment object for a particular server instance
     * @param    useBackupServerXml  uses back up server configuration if true 
     *
     * @return   manager object for the j2ee applications
     */
    public static AppsManager createAppsManager(InstanceEnvironment env,
            boolean useBackupServerXml) throws ConfigException {

        return new AppsManager(env, useBackupServerXml);
    }
   
    public static EjbModulesManager createEjbModuleManager(String serverId) 
	throws ConfigException
    {
	InstanceEnvironment env = new InstanceEnvironment(serverId);
	return new EjbModulesManager(env);
    }

    public static EjbModulesManager createEjbModuleManager(String installRoot, 
	    String serverId) throws ConfigException
    {
	return createEjbModuleManager(installRoot, serverId, true);
    }

    public static EjbModulesManager createEjbModuleManager(String installRoot, 
	    String serverId, boolean useBackupServerXml) throws ConfigException
    {
	InstanceEnvironment env = new InstanceEnvironment(installRoot,serverId);
	return new EjbModulesManager(env, useBackupServerXml);
    }

    /**
     * Returns a manager object stand alone ejb modules. It provides 
     * convenience functions to read and save data related to the given 
     * server instance.
     *
     * @param    env    environment object for a particular server instance
     * @param    useBackupServerXml  uses back up server configuration if true 
     *
     * @return   manager object for stand alone ejb modules
     */
    public static EjbModulesManager createEjbModuleManager(
            InstanceEnvironment env, boolean useBackupServerXml) 
            throws ConfigException {

        return new EjbModulesManager(env, useBackupServerXml);
    }

    public static ConnectorModulesManager createConnectorModulesManager(String serverId) 
	throws ConfigException
    {
	InstanceEnvironment env = new InstanceEnvironment(serverId);
	return new ConnectorModulesManager(env);
    }


    // START OF IASRI 4666602
    public static ConnectorModulesManager createConnectorModuleManager(
            InstanceEnvironment env, boolean useBackupServerXml) 
            throws ConfigException {
        return new ConnectorModulesManager(env, useBackupServerXml);        
    }

    // END OF IASRI 4666602    
    public static WebModulesManager createWebModuleManager(String serverId) 
	throws ConfigException
    {
	InstanceEnvironment env = new InstanceEnvironment(serverId);
	return new WebModulesManager(env);
    }


    public static WebModulesManager createWebModuleManager(String installRoot, 
	    String serverId) throws ConfigException
    {
	return createWebModuleManager(installRoot, serverId, true);
    }

    public static WebModulesManager createWebModuleManager(String installRoot, 
	    String serverId, boolean useBackupServerXml) throws ConfigException
    {
	InstanceEnvironment env = new InstanceEnvironment(installRoot,serverId);
	return new WebModulesManager(env, useBackupServerXml);
    }

    public static AppclientModulesManager createAppclientModulesManager(String serverId)
	    throws ConfigException
    {
	InstanceEnvironment env = new InstanceEnvironment(serverId);
	return new AppclientModulesManager(env);
    }

    public static AppclientModulesManager createAppclientModulesManager(InstanceEnvironment env)
	    throws ConfigException
    {
	return new AppclientModulesManager(env);
    }

}
