/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LogMgmtEventsNotificationListener.java
 *
 * Created on August 19, 2005, 1:18 PM
 */

package com.sun.enterprise.management.selfmanagement;

import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.logging.LogDomains;
import com.sun.enterprise.util.i18n.StringManager;
/**
 *
 * @author Harpreet Singh
 */
public class LogMgmtEventsNotificationListener implements NotificationListener {
  
    /** Logger for self management service */
    private static Logger _logger =  null;
  
    /** Local Strings manager for the class */
    private static StringManager localStrings = null;
                                                                                                                            
    static {
        _logger = LogDomains.getLogger(LogDomains.SELF_MANAGEMENT_LOGGER);
        localStrings = StringManager.getManager(LogMgmtEventsNotificationListener.class);
    }

    
    /**
     * Is logging turned on for this particular even. Key corresponds to 
     * the <i>record-event</i> from the event element in domain xml
     */
    public static final String RECORD_EVENT_KEY = ServerTags.RECORD_EVENT;
    
    /*
     * The logging level for logging events. An event is logged if the 
     * record-event is turned. Key corresponds to level in event element 
     * in domain xml.
     */
    public static final String RECORD_LOG_LEVEL_KEY = ServerTags.LEVEL;
        
    public static final String EVENT_TYPE_KEY = ServerTags.TYPE;
    
    public static final String EVENT_DESCRIPTION_KEY = ServerTags.DESCRIPTION;

    /** Creates a new instance of LogMgmtEventsNotificationListener */
    private LogMgmtEventsNotificationListener() {
        // do Nothing
    }

    public static LogMgmtEventsNotificationListener getInstance (){
        return new LogMgmtEventsNotificationListener ();
    }
    public void handleNotification(Notification notification, Object handback) {
        
        Map<String, String> property =
                (Map<String, String>) handback;
        
        if (property == null)
            return;
        
        String recordevent = null;;
        recordevent = (String)property.get(RECORD_EVENT_KEY);
	if (recordevent == null)
	   return;

        boolean recordEvent = false;
        if (recordevent != null){
            recordEvent = Boolean.valueOf(recordevent);
            
            if(recordEvent){
                try{
		    StringBuffer message  = 
			new StringBuffer(localStrings.
				getString("logMgmtEventsNotificationListener.prefix"));

                    String eventType = (String)property.get(EVENT_TYPE_KEY);

		    if (eventType != null){
			message.append (eventType);	
			message.append (":");
		    }
                    String logLevel = (String) property.get(RECORD_LOG_LEVEL_KEY);
	            if(logLevel == null){
			logLevel = Level.FINE.toString();	
		    }
		    message.append (logLevel);
		    message.append (":");
                    Level level = Level.parse(logLevel);

                    String description = (String) property.get(EVENT_DESCRIPTION_KEY);

		    if (description != null){
			message.append (description);
			message.append (":");
		   }
                    _logger.log(level, message.toString());
                } catch (IllegalArgumentException iae) {
                    _logger.log(Level.FINE, "Incorrect Log Level set for event. Cannot log event ", iae);
			iae.printStackTrace();
                } catch (NullPointerException npe){
                    _logger.log(Level.FINE, "Incorrect Log Level set for event. Cannot log event ", npe);
			npe.printStackTrace();
		}
            }
        }
    }
}
    
