/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.util.Set;

/**
 * Interface representing a collection of J2EEResources,
 * ordered by type and keyed by name.
 *
 * @author Kenneth Saks
 */
public interface J2EEResourceCollection {

    /**
     * Get all the resources of a given type.
     * @return Shallow copy of resource set. If there
     *         are no resources of the given type, an
     *         empty set is returned.
     */
    Set getResourcesByType(int type);

    /**
     * Get all the resources.
     */
    Set getAllResources();

    /**
     * Add a resource. This resource will replace any
     * existing one with the same type and name.
     */
    void addResource(J2EEResource resource);

    /**
     * Remove a resource. 
     * @return true if resource was removed, false if
     *         resource was not found
     */
    boolean removeResource(J2EEResource resource);

    /**
     * Remove all resources of the given type.  After
     * this call getResourcesByType(type) should return
     * an empty set.
     */
    void removeAllResourcesByType(int type);

    /**
     * Direct-access resource lookup.
     * @return J2EEResource if resource was found and
     *         null otherwise
     */
    J2EEResource getResourceByName(int type, String name);

}
