/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

/**
 * Interface for creating the various J2EEResource object types.
 *
 * @author Kenneth Saks
 */ 
public interface J2EEResourceFactory {

    /**
     * Load a J2EE Resource Collection from the local
     * j2ee installation.
     * @throws J2EEResourceException 
     */
    J2EEResourceCollection loadDefaultResourceCollection()
        throws J2EEResourceException;

    /**
     * Load a collection of resources from the data store 
     * represented by the given URL.
     * @throws J2EEResourceException 
     */
    J2EEResourceCollection loadResourceCollection(String resourcesURL) 
        throws J2EEResourceException;

    /**
     * Store a resource collection to the local j2ee installation.
     * @throws J2EEResourceException 
     */
    void storeDefaultResourceCollection(J2EEResourceCollection resources)
        throws J2EEResourceException;
    
    /**
     * Store a resource collection to the given URL
     * @throws J2EEResourceException 
     */
    void storeResourceCollection(J2EEResourceCollection resources, 
                                 String resourcesURL) 
        throws J2EEResourceException;

    /**
     * Create a resource of the given type and name.
     */
    J2EEResource createResource(int type, String name);

    /**
     * Create a new resource property.
     */
    ResourceProperty createProperty(String name);

}
