/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.io.Serializable;

/**
 * Resource info for Non-XA JDBC DataSources.
 *
 * @author Kenneth Saks
 */
public class JdbcResource extends J2EEResourceBase 
    implements Serializable {

    private String url_;    
    
    public JdbcResource(String name) {
        super(name);
    }

    protected J2EEResource doClone(String name) {
        JdbcResource clone = new JdbcResource(name);
        clone.setUrl(getUrl());
        return clone;
    }

    public int getType() {
        return J2EEResource.JDBC_RESOURCE;
    }

    public String getUrl() {
        return url_;
    }
    
    public void setUrl(String url) {
        url_ = url;
    }

    public String toString() {
        return "< JDBC Resource : " + getName() + " , " + getUrl() + " >";
            
    }
}
