/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt. * If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright 2006 Sun Microsystems, Inc. All rights reserved.
*/

package com.sun.enterprise.resource;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import static com.sun.enterprise.resource.ResourceConstants.*;

/** A class that holds utility/helper routines. Expected to contain static
*  methods to perform utility operations.
*
* @since Appserver 9.0
*/
public class ResourceUtilities {
     private ResourceUtilities()/*disallowed*/ {
   }

   /** Checks if any of the Resource in the given set has a conflict with
    * resource definitions in the domain.xml. A <b> conflict </b> is defined
    * based on the type of the resource. For example, a JDBC Resource has "jndi-name"
    * that is the identifying key where as for a JDBC Connection Pool, it is
    * the "name" that must be unique.
    * @param resSet a Set of Resource elements.
    * @param cc instance of ConfigContext that you want to confirm this against. May not be null.
    * @return a Set of Resource elements that contains conflicting elements from the given Set. This
    * method does not create any Resource elements. It just references an element in conflict
    * from a Set that is returned. If there are no conflicts, an empty Set is returned. This method
    * never returns a null. If the given Set is null, an empty Set is returned.
    * @throws ConfigException if there is any error with accessing the configuration
    * hierarchy.
    */
   public static Set<Resource> getResourceConfigConflicts(final Set<Resource> resSet,
       final ConfigContext cc) throws ConfigException {
             final Set<Resource> conflicts = new HashSet<Resource>();
       if (resSet != null) {
           for (final Resource res : resSet) {
               final String id = getIdToCompare(res);
               final ConfigBean sb = ResourceHelper.findResource(cc, id);
               if (sb != null) {
                   conflicts.add(res);
               }
           }
       }
       return ( conflicts );
   }
     private static String getIdToCompare(final Resource res) {
       final AttributeList attrs = res.getAttributes();
       final String type         = res.getType();
       String id;
       if (Resource.JDBC_CONNECTION_POOL.equals(type) ||
           Resource.CONNECTOR_CONNECTION_POOL.equals(type) ||
           Resource.RESOURCE_ADAPTER_CONFIG.equals(type) ||
           Resource.CONNECTOR_SECURITY_MAP.equals(type)) {
          id = getNamedAttributeValue(attrs, CONNECTION_POOL_NAME);   // this should come from refactored stuff TBD
       }
       else if (Resource.RESOURCE_ADAPTER_CONFIG.equals(type)) {
           id = getNamedAttributeValue(attrs, RESOURCE_ADAPTER_CONFIG_NAME);  // this should come from refactored stuff TBD
       }
       else {
           //it is OK to assume that this Resource will one of the *RESOURCEs?
           id = getNamedAttributeValue(attrs, JNDI_NAME); // this should come from refactored stuff TBD
       }
       return ( id );
   }
     private static String getNamedAttributeValue(final AttributeList attrs, final String aName) {
       String value = null;
       for (final Object obj : attrs) {
           if (obj instanceof Attribute) {
               final Attribute a = (Attribute) obj;
               if (aName.equals(a.getName())) {
                   value = a.getValue().toString();
               }
           }
       }
       return ( value );
   }
} 
