/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security.acl;

import java.security.Principal;
/**
 * @author Harish Prabandham
 */
public class WebResource extends Resource {
    private transient boolean wildcard;
    private transient String path;

    public WebResource(String app, String name, String method) {
        super(app,name,method);
        init(name);
    }

    private void init(String name)                                       
    {                                                                    
    	if (name == null)                                                    
            throw new IllegalArgumentException("name can't be null");
                                                                         
    	if (name.endsWith("/*") || name.equals("*")) {
            wildcard = true;
            if (name.length() == 1) {
                path = "";
            } else {
                path = name.substring(0, name.length()-1);
            }
    	} else {
            path = name;
    	}                                                                    
    }                                                                    

    public boolean equals(Object obj) {
        if(obj == this)
            return true;
        
        if ((obj == null) || (obj.getClass() != getClass()))
            return false;
        
        Resource r = (Resource) obj;
        
        return getApplication().equals(r.getApplication()) &&
            getMethod().equals(r.getMethod()) &&
            getName().equals(r.getName());
    }

    public boolean implies(Resource resource) {
	if(( resource == null) || (resource.getClass() != getClass())) 
		return false;

	WebResource that = (WebResource) resource;

	// Application name is not an issue in implies .....
	if(!getMethod().equals(that.getMethod()))
            return false;
		
	if(this.wildcard) {
            if (that.wildcard)
                // one wildcard can imply another
                return that.path.startsWith(path);
            else
                // make sure ap.path is longer so a/b/* doesn't imply a/b
                return (that.path.length() > this.path.length()) &&
                    that.path.startsWith(this.path);
	} else {
	    if (that.wildcard) {
                // a non-wildcard can't imply a wildcard
                return false;
            }
            else {
                return this.path.equals(that.path);
            }
	}
    }
}
