/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.auth.login;

import com.sun.appserv.security.AppservPasswordLoginModule;
import com.sun.enterprise.security.auth.realm.Realm;
import javax.security.auth.login.LoginException;

/**
 * Abstract base class for password-based login modules.
 * Newer implementations should extend
 * com.sun.appserv.security.AbstractLoginModule. This class is provided for
 * backward compatibility and is a candidate for deprecation.
 *
 */
public abstract class PasswordLoginModule extends AppservPasswordLoginModule
{

    /**
     * Maintain RI compatibility.
     *
     * <P>This is a convenience method which can be used by subclasses
     * to complete the steps required by RI legacy authentication code.
     * Most of this should go away if a clean JAAS/Subject based
     * infrastructure is provided. But for now this must be done.
     *
     * <P>Note that this method is called after the authentication
     * has succeeded. If authentication failed do not call this method.
     * 
     * <P>A lot of the RI behavior is still present here. Some of the
     * most notable points to remember:
     * <ul>
     *  <li>Global instance field succeeded is set to true by this method.
     *
     * @param username Name of authenticated user.
     * @param password Password of this user.
     * @param theRealm Current Realm object for this authentication.
     * @param groups String array of group memberships for user (could be
     *     empty). 
     * @returns void
     *
     */
    public final void commitAuthentication(String username,
                                        String password,
                                        Realm theRealm,
                                        String[] groups)
    {
        commitUserAuthentication(groups);
    }
    /**
     * Older implementations can implement authenticate. While new implementation
     * calls authenticateUser
     * @throws LoginException
     */
    protected final void authenticateUser () throws LoginException{
        authenticate();
    }

    /**
     * Perform authentication decision.
     * Method returns silently on success and returns a LoginException
     * on failure.
     * To be implmented by sub-classes
     * @return void authenticate returns silently on successful authentication.
     * @throws com.sun.enterprise.security.LoginException on authentication failure.
     *
     */
    abstract protected void authenticate()
        throws LoginException;
}
