/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server;

import java.util.Properties;
import com.sun.enterprise.server.pluggable.InternalServicesList;

/**
 * pluggable interface (this class will provide ApplicationServer
 * with the right lifecycles array)
 */
public class TomcatServices implements InternalServicesList {

   public String[][] getServicesByName() {
        // AdminService need to be first one due to RMI timeup issue.
        // We need to set securityManager before any runtime.
        // So, we put the following assumption in the code below:
        // 1) The constructor of AdminServiceLifeCycle will not 
        //    not create any runtime object and cannot access SSL.
        // 2) Any LifeCycle should not access SSL in the constructor of
        //    LifeCycle.  This should be done in onInitialization.
	String[][] servicesByName = {
	        {"AdminService", 
	        "com.sun.enterprise.admin.server.core.AdminServiceLifeCycle"},
                //Remote JMX (JSR 160) Connector
                 {"RemoteJmxConnector",
                  "com.sun.enterprise.admin.server.core.JmxConnectorLifecycle"},
                {"SecurityService",
                "com.sun.enterprise.security.SecurityLifecycle"},
                {"SelfManagement Service",
                "com.sun.enterprise.management.selfmanagement.SelfManagementService"},                        
	        {"PersistenceManagerService", 
		"com.sun.jdo.spi.persistence.support.sqlstore.ejb.PersistenceManagerServiceImpl"},	
		{"JMSProvider", 
		"com.sun.enterprise.jms.JmsProviderLifecycle"},
		{"WSMgmt Service", 
		"com.sun.enterprise.admin.wsmgmt.lifecycle.AppServWSMgmtAdminLifeCycle"},

		{"System Application Service", 
		"com.sun.enterprise.server.SystemAppLifecycle"},
		{"LifecycleModuleService", 
		"com.sun.appserv.server.LifecycleModuleService"},
		{"Application Service", 
		"com.sun.enterprise.server.ApplicationLifecycle"},
	        {"Servlet/JSP Service", 
		"com.sun.enterprise.web.PEWebContainerLifecycle"},
		{"Pre90LifecycleModuleService", 
		"com.sun.appserv.server.Pre90LifecycleModuleService"},
                {"DeclarativeLifecycleEventService",
                "com.sun.enterprise.admin.selfmanagement.event.DeclarativeLifecycleEventService"},
                //JavaEE Service Engine - Shasta Integration
                 {"JavaEEServiceEngine", "com.sun.enterprise.jbi.serviceengine.bridge.JavaEEServiceEngineLifeCycle"}
                        
	};
	return servicesByName;

   }

}
