/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.logging.LogDomains;

import java.util.logging.Logger;
import java.util.logging.Level;
import java.util.List;
import java.lang.reflect.Method;
import java.lang.reflect.Constructor;
import java.io.File;

public  class AppVerifier {

    static Logger _logger=LogDomains.getLogger(LogDomains.APPVERIFY_LOGGER);
    Method verify = null;
    Object verifier =null;
    
    public AppVerifier() throws Exception {
        init();
    }

    private void init() throws Exception {
        String name = "com.sun.enterprise.tools.verifier.Verifier";
        try {
            Class verifierClass = Class.forName(name);
            verify = verifierClass.getDeclaredMethod("verify",
                    new Class[] {Application.class,
                                 AbstractArchive.class,
                                 List.class,
                                 File.class});
            Constructor constructor = verifierClass.getDeclaredConstructor();
            verifier = constructor.newInstance();
        } catch (ClassNotFoundException e) {
            _logger.log(Level.SEVERE,"verifier.class.notfound",
                    new Object[] {name});
            throw e;
        }
        catch (NoSuchMethodException e) {
            _logger.log(Level.SEVERE,"verifier.method.notfound",e);
            throw e;
        } catch (Exception e) {
            _logger.log(Level.SEVERE,"verifier.intialization.error", e);
            throw e;
        }
    }

    public void verify(Application application, 
                       AbstractArchive abstractArchive,
                       List classPath,
                       File jspOutDir) throws Exception{
        Object result = verify.invoke(verifier,
                new Object[] {application, abstractArchive, classPath, jspOutDir});
        if(((Integer)result).intValue() > 0)
            throw new Exception("Some verifier tests Failed.");
    }
}
