/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * FileStrategyBuilder.java
 *
 * Created on September 30, 2002, 1:42 PM
 */

package com.sun.enterprise.web;


import java.util.logging.Logger;
import java.util.logging.Level;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.FileStore;
import org.apache.catalina.session.PersistentManager;
//FIXME remove
//import com.iplanet.ias.tools.common.dd.webapp.SessionManager;
//import com.sun.enterprise.tools.common.dd.webapp.SessionManager;
import com.sun.enterprise.deployment.runtime.web.SessionManager;


public class FileStrategyBuilder extends BasePersistenceStrategyBuilder implements PersistenceStrategyBuilder {
    
    /** Creates a new instance of FileStrategyBuilder */
    /*
    public FileStrategyBuilder() {
    }*/    
    
    public void initializePersistenceStrategy(Context ctx, SessionManager smBean) {
        super.initializePersistenceStrategy(ctx, smBean);
        
        Object[] params = { ctx.getPath() };
        _logger.log(Level.INFO, "webcontainer.filePersistence", params);
        PersistentManager mgr = new PersistentManager();
        mgr.setMaxActiveSessions(maxSessions);
        //FIXME: what is the replacement for setCheckInterval
        //mgr.setCheckInterval(reapInterval);        
        mgr.setMaxIdleBackup(0);           // FIXME: Make configurable

        FileStore store = new FileStore();
        //store.setCheckInterval(storeReapInterval);
        store.setDirectory(directory);
        mgr.setStore(store);
        
        //for intra-vm session locking
        StandardContext sctx = (StandardContext) ctx;
        sctx.restrictedSetPipeline(new PESessionLockingStandardPipeline(sctx));        
        
        //special code for Java Server Faces
        if(ctx.findParameter(JSF_HA_ENABLED) == null) {
            ctx.addParameter(JSF_HA_ENABLED, "true");
        }        
        //START OF 6364900
        mgr.setSessionLocker(new PESessionLocker(ctx));
        //END OF 6364900        
        ctx.setManager(mgr); 
        
        //this must be after ctx.setManager(mgr);
        //StandardContext sctx = (StandardContext) ctx;        
        if(!sctx.isSessionTimeoutOveridden()) {
           mgr.setMaxInactiveInterval(sessionMaxInactiveInterval); 
        }        
    }    
    
}
