/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.web.deploy;

import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.InitializationParameter;

import org.apache.catalina.deploy.FilterDef;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.io.Serializable;


/**
 * Decorator of class <code>org.apache.catalina.deploy.FilterDef</code>
 *
 * @author Jean-Francois Arcand
 */

public class FilterDefDecorator extends FilterDef{

    /**
     * The set of initialization parameters for this filter, keyed by
     * parameter name.
     */
    private Map parameters = null;
                                    
    private ServletFilter decoree;
    
    public FilterDefDecorator(ServletFilter decoree){
        this.decoree = decoree;
        Vector initParams = decoree.getInitializationParameters();
        InitializationParameter initParam; 
        for (int i=0; i < initParams.size(); i++){
           initParam = (InitializationParameter)initParams.get(i);
           addInitParameter( initParam.getName(),initParam.getValue() );              
        }  
    }



    // ------------------------------------------------------------- Properties


    public String getDescription() {
        return decoree.getDescription();
    }

    public String getDisplayName() {
        return decoree.getDisplayName();
    }
 
 
    public String getFilterClass() {
        return decoree.getClassName();
    }
  
    public String getFilterName() {
        return decoree.getName();
    }

    public String getLargeIcon() {
        return decoree.getLargeIconUri();
    }


    public String getSmallIcon() {
        return decoree.getSmallIconUri();
    }



   
}
